/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.core.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.satisfy.meadow.client.gui.handler.CheeseFormGuiHandler;
import net.satisfy.meadow.core.block.CheeseFormBlock;
import net.satisfy.meadow.core.recipes.CheeseFormRecipe;
import net.satisfy.meadow.core.registry.EntityTypeRegistry;
import net.satisfy.meadow.core.registry.ObjectRegistry;
import net.satisfy.meadow.core.registry.RecipeRegistry;
import net.satisfy.meadow.core.registry.TagRegistry;
import net.satisfy.meadow.core.world.ImplementedInventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CheeseFormBlockEntity
extends BlockEntity
implements BlockEntityTicker<CheeseFormBlockEntity>,
MenuProvider,
ImplementedInventory {
    private NonNullList<ItemStack> inventory;
    public static final int CAPACITY = 3;
    public static final int COOKING_TIME_IN_TICKS = 1800;
    private static final int OUTPUT_SLOT = 0;
    private int fermentationTime = 0;
    protected float experience;
    private static final int[] SLOTS_FOR_SIDE = new int[]{2};
    private static final int[] SLOTS_FOR_UP = new int[]{1};
    private static final int[] SLOTS_FOR_DOWN = new int[]{0};
    private final ContainerData propertyDelegate = new ContainerData(){

        public int m_6413_(int index) {
            if (index == 0) {
                return CheeseFormBlockEntity.this.fermentationTime;
            }
            if (index == 1) {
                return 1800;
            }
            return 0;
        }

        public void m_8050_(int index, int value) {
            if (index == 0) {
                CheeseFormBlockEntity.this.fermentationTime = value;
            }
        }

        public int m_6499_() {
            return 2;
        }
    };

    public CheeseFormBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EntityTypeRegistry.CHEESE_FORM_BLOCK_ENTITY.get(), pos, state);
        this.inventory = NonNullList.m_122780_((int)3, (Object)ItemStack.f_41583_);
    }

    @Override
    public int @NotNull [] m_7071_(Direction side) {
        if (side.equals((Object)Direction.UP)) {
            return SLOTS_FOR_UP;
        }
        if (side.equals((Object)Direction.DOWN)) {
            return SLOTS_FOR_DOWN;
        }
        return SLOTS_FOR_SIDE;
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.inventory = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
        this.fermentationTime = nbt.m_128448_("fermentationTime");
        this.experience = nbt.m_128457_("experience");
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
        nbt.m_128350_("experience", this.experience);
        nbt.m_128376_("fermentationTime", (short)this.fermentationTime);
    }

    public void tick(Level world, BlockPos pos, BlockState state, CheeseFormBlockEntity blockEntity) {
        boolean done;
        if (world.f_46443_) {
            return;
        }
        RegistryAccess manager = world.m_9598_();
        CheeseFormRecipe recipeType = world.m_7465_().m_44015_((RecipeType)RecipeRegistry.CHEESE.get(), (Container)blockEntity, world).orElse(null);
        boolean working = this.canCraft(recipeType, manager);
        if (working) {
            ++this.fermentationTime;
            if (this.fermentationTime >= 1800) {
                this.fermentationTime = 0;
                this.craft(recipeType, manager);
                this.m_6596_();
            }
        } else {
            this.fermentationTime = 0;
        }
        boolean bl = done = !((ItemStack)this.inventory.get(0)).m_41619_();
        if ((Boolean)state.m_61143_((Property)CheeseFormBlock.WORKING) != working || (Boolean)state.m_61143_((Property)CheeseFormBlock.DONE) != done) {
            world.m_46597_(pos, (BlockState)((BlockState)state.m_61124_((Property)CheeseFormBlock.WORKING, (Comparable)Boolean.valueOf(working))).m_61124_((Property)CheeseFormBlock.DONE, (Comparable)Boolean.valueOf(done)));
        }
    }

    private boolean canCraft(CheeseFormRecipe recipe, RegistryAccess manager) {
        if (recipe == null || recipe.m_8043_(manager).m_41619_()) {
            return false;
        }
        if (this.areInputsEmpty()) {
            return false;
        }
        ItemStack itemStack = this.m_8020_(0);
        return itemStack.m_41619_() || itemStack.m_150930_(recipe.m_8043_(manager).m_41720_());
    }

    private boolean areInputsEmpty() {
        int emptyStacks = 0;
        for (int i = 1; i <= 2; ++i) {
            if (!this.m_8020_(i).m_41619_()) continue;
            ++emptyStacks;
        }
        return emptyStacks == 2;
    }

    private void craft(CheeseFormRecipe recipe, RegistryAccess manager) {
        if (!this.canCraft(recipe, manager)) {
            return;
        }
        ItemStack recipeOutput = recipe.m_8043_(manager);
        ItemStack outputSlotStack = this.m_8020_(0);
        if (outputSlotStack.m_41619_()) {
            ItemStack output = recipeOutput.m_41777_();
            this.m_6836_(0, output);
        } else if (outputSlotStack.m_150930_(recipeOutput.m_41720_())) {
            outputSlotStack.m_41769_(recipeOutput.m_41613_());
        }
        ItemStack slot1Stack = this.m_8020_(1);
        if (recipe.m_7527_().stream().anyMatch(entry -> entry.test(slot1Stack))) {
            if (slot1Stack.m_204117_(TagRegistry.MILK_BUCKET)) {
                this.m_6836_(1, Items.f_42446_.m_7968_());
            } else if (slot1Stack.m_204117_(TagRegistry.WOODEN_MILK_BUCKET)) {
                this.m_6836_(1, ((Item)ObjectRegistry.WOODEN_BUCKET.get()).m_7968_());
            } else {
                this.m_7407_(1, 1);
            }
        }
        ItemStack slot2Stack = this.m_8020_(2);
        if (recipe.m_7527_().stream().anyMatch(entry -> entry.test(slot2Stack))) {
            if (slot2Stack.m_204117_(TagRegistry.MILK_BUCKET)) {
                this.m_6836_(2, Items.f_42446_.m_7968_());
            } else if (slot2Stack.m_204117_(TagRegistry.WOODEN_MILK_BUCKET)) {
                this.m_6836_(2, ((Item)ObjectRegistry.WOODEN_BUCKET.get()).m_7968_());
            } else if (slot2Stack.m_204117_(TagRegistry.MILK)) {
                ItemStack bucket = slot2Stack.m_41720_() == ObjectRegistry.WOODEN_MILK_BUCKET.get() ? ((Item)ObjectRegistry.WOODEN_BUCKET.get()).m_7968_() : Items.f_42446_.m_7968_();
                this.m_6836_(2, bucket);
            } else {
                this.m_7407_(2, 1);
            }
        }
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    @Override
    public void m_6836_(int slot, ItemStack stack) {
        ItemStack stackInSlot = (ItemStack)this.inventory.get(slot);
        boolean dirty = !stack.m_41619_() && ItemStack.m_41656_((ItemStack)stack, (ItemStack)stackInSlot) && ItemStack.m_41728_((ItemStack)stack, (ItemStack)stackInSlot);
        this.inventory.set(slot, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        if (!(slot != 1 && slot != 2 || dirty)) {
            this.fermentationTime = 0;
            this.m_6596_();
        }
    }

    @Override
    public boolean m_6542_(Player player) {
        assert (this.f_58857_ != null);
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237113_((String)"Cheese Form");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int syncId, Inventory inv, Player player) {
        return new CheeseFormGuiHandler(syncId, inv, (Container)this, this.propertyDelegate);
    }
}

